<?php

	/* Menu */

	add_action ( 'admin_menu', 'wpblmachine_add_admin_menu' );

	/**
	 * add an option page attached with a setting submenu
	 */
	function wpblmachine_add_admin_menu() {
		if( wpblmachine_is_valid_api() ) {
			$page1 = add_menu_page('Backlink Machine', 'Backlink Machine', 'manage_options', 'wp-backlink-machine', 'wpblmachine_screen1');
			$page3 = add_submenu_page('wp-backlink-machine', 'Log', 'Log', 'manage_options', 'wp-backlink-log', 'wpblmachine_screen_log');
			$page2 = add_submenu_page('wp-backlink-machine', 'Settings', 'Settings', 'manage_options', 'wp-backlink-machine-settings', 'wpblmachine_screen_settings');
			$page4 = add_submenu_page('wp-backlink-machine', 'Help', 'Help', 'manage_options', 'wp-backlink-machine-support', 'wpblmachine_screen_help');
		}
		else {
			$page1 = add_menu_page('Backlink Machine', 'Backlink Machine', 'manage_options', 'wp-backlink-machine', 'wpblmachine_screen_settings');
		}
		add_action( "admin_print_scripts-$page1", 'wpblmachine_admin_scripts' );
		add_action( "admin_print_styles-$page1", 'wpblmachine_admin_style' );
		if( wpblmachine_is_valid_api() ) {
			add_action( "admin_print_scripts-$page2", 'wpblmachine_admin_scripts' );
			add_action( "admin_print_styles-$page2", 'wpblmachine_admin_style' );
			add_action( "admin_print_scripts-$page3", 'wpblmachine_admin_scripts' );
			add_action( "admin_print_styles-$page3", 'wpblmachine_admin_style' );
			add_action( "admin_print_scripts-$page4", 'wpblmachine_admin_scripts' );
			add_action( "admin_print_styles-$page4", 'wpblmachine_admin_style' );
		}
	}

	function wpblmachine_admin_scripts() {

		wp_register_script( 'wpblmachine_admin_js', WPBLMACHINE_URL . '/js/wpblmachine-admin.js', array('jquery'), WPBLMACHINE_VERSION);

		$script_vars = array(
			'admin_url' => admin_url( 'admin.php?page=wp-backlink-machine' )
			 );
		wp_localize_script( 'wpblmachine_admin_js', 'wpblmachine_vars', $script_vars );
		wp_enqueue_script( 'wpblmachine_admin_js');

		wp_register_script( 'wpblmachine-jquery-modal',
		        WPBLMACHINE_URL . '/js/jquery.modal.js',
		        array( 'jquery' ) );
		wp_enqueue_script( 'wpblmachine-jquery-modal');
	}

	function wpblmachine_admin_style() {
  		wp_register_style('wpblmachine_font_awesome_css', '//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', array(), WPBLMACHINE_VERSION);
  	  	wp_enqueue_style('wpblmachine_font_awesome_css');

  	  	wp_register_style('wpblmachine_custom_css', WPBLMACHINE_URL . '/css/wpblmachine-admin.css', array(), WPBLMACHINE_VERSION);
  	  	wp_enqueue_style('wpblmachine_custom_css');
  	}

  	function wpblmachine_screen1() {
		if (! current_user_can ( 'manage_options' ))
			wp_die ( 'You don\'t have access to this page.' );
		if (! user_can_access_admin_page ())
			wp_die ( __ ( 'You do not have sufficient permissions to access this page', 'wp-backlinks-machine' ) );
		$page = isset( $_GET['pagenum'] ) ? intval( $_GET['pagenum'] ) : 1;
		$post_type = isset( $_GET['posttype'] ) ? $_GET['posttype'] : 'post';
		$search_term = isset( $_POST['sterm'] ) ? $_POST['sterm'] : '';
		$post_type_details = get_post_type_object( $post_type );
		$post_type_name = $post_type_details->labels->name;
  		?>
  			<div class="wrap">
  			<img src="<?php echo WPBLMACHINE_URL;?>/img/logo2.png" alt="">
  			<?php wpblmachine_print_remaining_backlinks(); ?>
  			<br/>
  			<div style="float:right"><b>Display: </b> <?php wpblmachine_post_type_selector( $post_type ); ?></div><h1><?php echo $post_type_name;?></h1>
  			<br/>
  			<div class="searcher-posts" style="margin-bottom:10px">
  				<form action="<?php echo admin_url('admin.php?page=wp-backlink-machine&posttype='.$post_type);?>" method="POST">
				<b>Search:</b>
					<input type="text" name="sterm" value="<?php echo $search_term;?>">
					<input type="submit" value="Search" class="button button-primary">
					<input type="button" value="Reset Search" class="button button-secondary" id="do-reset-term">
				</form>
  			</div>
  			<?php wpblmachine_print_posts_list( $post_type, $search_term, $page, 50 ); ?>
  			</div>
  			<?php wpblmachine_popup(); ?>
  		<?php
  	}

  	add_action( 'admin_init', 'wpblmachine_check_save_settings', -5 );

  	function wpblmachine_check_save_settings() {
  		if( isset( $_POST['blmachine_save_settings'] ) ) {
  			$already_valid = isset( $_POST['blmachine_already_valid'] );
  			$valid = wpblmachine_save_settings();
  			if( $valid ) {
  				if( ! $already_valid )
  					wp_redirect( admin_url( 'admin.php?page=wp-backlink-machine' ) );
  				else
  					wp_redirect( admin_url( 'admin.php?page=wp-backlink-machine-settings' ) );
  				exit();
  			}
  			else {
  				if( !wpblmachine_is_valid_api() )
  					wp_redirect( admin_url( 'admin.php?page=wp-backlink-machine&apiinvalid=true' ) );
  				else
  					wp_redirect( admin_url( 'admin.php?page=wp-backlink-machine-settings&apiinvalid=true' ) );
  				exit();	
  			}
  		}
  	}

  	function wpblmachine_screen_settings() {
  		// delete_option( 'wpblmchine_valid_api');
		if (! current_user_can ( 'manage_options' ))
			wp_die ( 'You don\'t have access to this page.' );
		if (! user_can_access_admin_page ())
			wp_die ( __ ( 'You do not have sufficient permissions to access this page', 'wp-backlinks-machine' ) );

		$settings = wpblmachine_get_plugin_settings();
  		?>
  			<div class="wrap">
				<img src="<?php echo WPBLMACHINE_URL;?>/img/logo2.png" alt="">
				<br/>
				<h1>Settings</h1>
				<br/>
				<?php 
					if( !wpblmachine_is_valid_api() )
						echo '<p>Enter your Backlink Machine e-mail and API Key to start using the plugin</p>';
				?>
				<form action="" method="post">
					<table class="form-table">
						<tr valign="top">
							<th scope="row">Your e-mail</th>
							<td>
								<input type="email" class="regular-text" name="wpblmachine_email" placeholder="Enter your e-mail" value="<?php echo empty( $settings['email'] ) ? '' : $settings['email']; ?>"><br/>
								<span class="description">The e-mail you used to sign-up for Backlink Machine</span>
							</td>
						</tr>

						<tr valign="top">
							<th scope="row">Your API Key</th>
							<td>
								<input type="text" class="regular-text" name="wpblmachine_apikey" placeholder="Enter your API key" value="<?php echo empty( $settings['apikey'] ) ? '' : $settings['apikey']; ?>"><br/>
								<span class="description">Your Backlink Machine API Key. Get it <a href="https://backlinkmachine.com/app" target="_blank">here</a></span>
								<?php if( isset( $_GET['apiinvalid'] ) && $_GET['apiinvalid'] ) {
										echo '<p style="color:red;font-weight:bold">Error: your API Key is not valid, please check again</p>';
								}
								?>
							</td>
						</tr>
						<tr valign="top" <?php if( !wpblmachine_is_valid_api() ) echo 'style="display:none";'?>>
							<th scope="row">Get backlinks automatically for new posts/pages</th>
							<td>
								<input type="checkbox" name="wpblmachine_auto" id="wpblmachine_auto" value="1" <?php checked( isset( $settings['auto'] ) ? $settings['auto'] : 0 ); ?>"><br/>
								<span class="description">If you check this, every new post or page that you publish will get backlinks automatically (you need to fill the keywords box before publishing the post/page)</span>
							</td>
						</tr>
						<tr valign="top" <?php if( !wpblmachine_is_valid_api() || !isset( $settings['auto'] ) || ! $settings['auto']  ) echo 'style="display:none";'?>  id="num-backlinks-row">
							<th scope="row">Number of backlinks for new posts/pages</th>
							<td>
								<?php wpblmachine_backlinks_num_select( ( isset( $settings['num_blinks'] ) ? $settings['num_blinks'] : 0 ), true );?><br/>
								<span class="description">How many new backlinks will each new post/page get</span>
							</td>
						</tr>
            <tr valign="top" <?php if( !wpblmachine_is_valid_api() || !isset( $settings['auto'] ) || ! $settings['auto'] ) echo 'style="display:none";'?> id="kw-tags-row">
              <th scope="row">Use post tags as keywords for new posts</th>
              <td>
                <input type="checkbox" name="wpblmachine_kw_tags" id="wpblmachine_kw_tags" value="1" <?php checked( isset( $settings['kw_tags'] ) ? $settings['kw_tags'] : 0 ); ?>"><br/>
                <span class="description">If you check this, every new post that you publish will use post tags as keywords when getting automatic backlinks</span>
              </td>
            </tr>
            <tr valign="top" <?php if( !wpblmachine_is_valid_api() || !isset( $settings['auto'] ) || ! $settings['auto']  ) echo 'style="display:none";'?>  id="standard-kw-row">
              <th scope="row">Default Keywords<br/>(one per line)</th>
              <td>
                <textarea class="regular-text" name="wpblmachine_default_kw" rows="5" placeholder="Keywords, one per line"><?php echo (isset( $settings['default_kw'] ) ? $settings['default_kw'] : '');?></textarea><br/>
                <span class="description">If no keywords are selected for the post, these will be used instead (leave empty if you do not want new backlinks for new posts/pages) unless you specifically set the keywords in each post</span>
              </td>
            </tr>
						<tr valign="top">
							<th scope="row">&nbsp;</th>
							<td>
								<?php if( wpblmachine_is_valid_api() ) echo '<input type="hidden" name="blmachine_already_valid" value="1">';?>
								<input type="hidden" name="blmachine_save_settings" value="1">
								<input type="submit" value="Save" class="button button-primary">
							</td>
						</tr>
					</table>
				</form>
  			</div>
  		<?php
  	}


	function wpblmachine_screen_log() {
		if (! current_user_can ( 'manage_options' ))
			wp_die ( 'You don\'t have access to this page.' );
		if (! user_can_access_admin_page ())
			wp_die ( __ ( 'You do not have sufficient permissions to access this page', 'wp-backlinks-machine' ) );
		?>
			<div class="wrap">
			<img src="<?php echo WPBLMACHINE_URL;?>/img/logo2.png" alt="">
			<br/>
			<h1>Log</h1>
			<br/>
			<?php wpblmachine_print_log(); ?>
			</div>
		<?php
	}

  	function wpblmachine_screen_help() {
 		if (! current_user_can ( 'manage_options' ))
 			wp_die ( 'You don\'t have access to this page.' );
 		if (! user_can_access_admin_page ())
 			wp_die ( __ ( 'You do not have sufficient permissions to access this page', 'wp-backlinks-machine' ) );
   		?>
   			<div class="wrap">
   			<img src="<?php echo WPBLMACHINE_URL;?>/img/logo2.png" alt="">
   			<br/>
   			<h1>Support</h1>
   			<br/>
   			<p>Please watch this step-by-step video on how to use Backlink Machine</p>
   			<iframe width="853" height="480" src="https://www.youtube.com/embed/6pSh3k2kMG8?rel=0&amp;controls=0&amp;showinfo=0" frameborder="0" allowfullscreen></iframe>
   			<br/>
   				<br/>
   				<h2>Frequently Asked Questions</h2>
   				<h4>1. I've submitted a backlink job request, how long do I have to wait to be able to see my report?</h4>
   				<p>Reports are usually available after 24 to 48 hours. If it has been more than 3 days and you still can't access or view your report, please let us know and we'll look into it</p>

   				<h4>2. Are all links added at once?</h4>
   				<p>To keep a low profile, not all backlinks are created straight away; instead, they are drip fed for several days, using our internal SEO algorithm plus a random factor; however you can usually access the report after 48 hours (even when some of the backlinks might not be live yet).</p>

   				<h4>3. I ordered x backlinks, but in the report I see more than I requested.</h4>
   				<p>When you order backlinks for any post from your WordPress site using the plugin, or from our members area,  you will automatically get 20% extra backlinks. Eg, if you order 10 you will get 12 backlinks built.</p>
   				<p>Those extra backlinks are not deducted from your backlink count</p>

   				<h4>4. Do backlink credits ever expire?</h4>
   				<p>No, never. You can use them whenever you want. Also, if you have a monthly subscription, any unused backlink credits are rolled over to next month.</p>

   				<h4>5. I need extra backlinks, can I purchase them from you?</h4>
   				<p>Absolutely, you can top up your account with our backlink packages. You can find more info <a href="https://backlinkmachine.com/app/buy-credits.php">here</a>.</p>
   				<p>You can also check our monthly subscription <a href="http://backlinkmachine.convertri.com/oto1" target="_blank">here</a>.</p>

   				<h4>6. Does the Backlink Machine plugin work with any WordPress theme?</h4>
   				<p>Yes, since it connects with our backend SAAS app, it can work with most of the popular WordPress themes as long as your site is self hosted and not a free WordPress site on wordpress.org.</p>

   				<h4>7. Do you have any recommendation on how to improve the SEO boost to my post?</h4>
   				<p>Read the BONUS guide on our backlinking strategy and follow it along with using Backlink Machine on your site to get the best possible results and rankings.</p>

   				<h4>8. How many Backlinks do you recommend to add to each post?</h4>
   				<p>In our experience, adding at least 50 backlinks using backlink machine can often give you decent rankings if the topic or keywords are not too competitive but it highly depends on the niche, keyword and the authority of your site. We cannot guarantee any rankings as a lot of other factors are responsible for ranking.</p>
   				<br/>
   				<br/>
   			<p>If you have any issues, please open a support ticket <a href="http://customerhelpdesk.in" target="_blank">here</a>.</p>
   			</div>
   		<?php
  	}


  	// Metabox

  	/* Create one or more meta boxes to be displayed on the post editor screen. */
  	function wpblmachine_add_post_meta_boxes() {
  	  add_meta_box(
  	    'wpblmachine-keyword',      // Unique ID
  	    esc_html__( 'Baklinks Machine Keywords', 'backlinks-machine' ),    // Title
  	    'wpblmachine_post_class_meta_box',   // Callback function
  	    array( 'post', 'page'),         // Admin page (or post type)
  	    'side',         // Context
  	    'default'         // Priority
  	  );
  	}

  	/* Display the post meta box. */
  	function wpblmachine_post_class_meta_box( $post ) { ?>

  	  <?php wp_nonce_field( basename( __FILE__ ), 'wpblmachine_post_class_nonce' ); ?>
  	  <?php $val = get_post_meta( $post->ID, 'wpblmachine_keywords', true ) ; ?>
  	  <p>
  	    <label for="wpblmachine-show-link"><?php _e( "Enter the keywords you would like to use to get backlinks (one per line)", 'wpblmachine' ); ?></label>
  	    <br />
  	    <br />
  	    <textarea class="widefat" name="wpblmachine_keywords"><?php echo $val;?></textarea>
  	  </p>
  	<?php
  	}


  	/* Fire our meta box setup function on the post editor screen. */
  	add_action( 'load-post.php', 'wpblmachine_post_meta_boxes_setup' );
  	add_action( 'load-post-new.php', 'wpblmachine_post_meta_boxes_setup' );

  	/* Meta box setup function. */
  	function wpblmachine_post_meta_boxes_setup() {

  	  /* Add meta boxes on the 'add_meta_boxes' hook. */
  	  add_action( 'add_meta_boxes', 'wpblmachine_add_post_meta_boxes' );

  	  /* Save post meta on the 'save_post' hook. */
  	  add_action( 'save_post', 'wpblmachine_save_post_class_meta', 10, 2 );
  	}

  	/* Save the meta box's post metadata. */
  	function wpblmachine_save_post_class_meta( $post_id, $post ) {

		/* Verify the nonce before proceeding. */
		if ( !isset( $_POST['wpblmachine_post_class_nonce'] ) || !wp_verify_nonce( $_POST['wpblmachine_post_class_nonce'], basename( __FILE__ ) ) )
		return $post_id;

		/* Get the post type object. */
		$post_type = get_post_type_object( $post->post_type );

		/* Check if the current user has permission to edit the post. */
		if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

		/* Get the posted data and sanitize it for use as an HTML class. */
		$new_meta_value = ( isset( $_POST['wpblmachine_keywords'] ) ? esc_textarea( $_POST['wpblmachine_keywords'] ) : '' );

		update_post_meta( $post_id, 'wpblmachine_keywords', $new_meta_value );
  	}

  	function wpblmachine_post_type_selector( $val = 'post' ) {
  		$post_types = wpblmachine_get_post_types();
  		$str = '<select id="wpblm-post-types">';
  		if( $post_types ) {
  			// var_dump($post_types);
  			foreach( $post_types as $type ) {
  				if( $type->name == 'attachment' ) // Ignore Media
  					continue;
  				$str .= '<option value="'.$type->name.'" '.selected( $type->name, $val, false ).'>'.$type->label.'</option>';
  			}
  		}
  		$str .= '</select>';
  		echo $str;
  	}


  	add_filter( 'plugin_action_links_' . WPBLMACHINE_PLUGIN_NAME.'/'.WPBLMACHINE_PLUGIN_NAME.'.php', 'backlinkmachine_add_plugin_action_links' );

  	function backlinkmachine_add_plugin_action_links( $links ) {
  		$tagmachine_options = array(
  				'Support' => '<a target="_blank" href="http://backlinkmachine.com/members/help.html">Support</a>'
  		);

		$tagmachine_options = array_merge( $tagmachine_options,
			array(
							'Upgrade to Pro' => '<a target="_blank" href="http://backlinkmachine.convertri.com/oto1" style="font-weight:bold;color:red">Upgrade to Pro</a>'
				)
		);


  		return array_merge(
  			$links,
  			$tagmachine_options
  		);
  	}
?>