<?php
	function wpblmachine_save_settings() {
		$settings = array();
		$settings['email'] = isset( $_POST['wpblmachine_email'] ) ? trim( $_POST['wpblmachine_email'] ) : '';
		$settings['apikey'] = isset( $_POST['wpblmachine_apikey'] ) ? trim( $_POST['wpblmachine_apikey'] ) : '';
		$settings['auto'] = isset( $_POST['wpblmachine_auto'] ) ? $_POST['wpblmachine_auto'] : '';
		$settings['kw_tags'] = isset( $_POST['wpblmachine_kw_tags'] ) ? $_POST['wpblmachine_kw_tags'] : '';
		$settings['num_blinks'] = isset( $_POST['wpbl-backlinks-num'] ) ? intval( $_POST['wpbl-backlinks-num'] ) : 0;
		$settings['default_kw'] = isset( $_POST['wpblmachine_default_kw'] ) ? $_POST['wpblmachine_default_kw'] : '';
		wpblmachine_save_plugin_settings( $settings );
		delete_transient( 'wpblmachine_rem_links' );
		if( wpblmachine_api_test_api_key( $settings['email'], $settings['apikey'] ) ) {
			wpblmachine_set_valid_api();
			return true;
		}
		return false;
	}

	function wpblmachine_get_plugin_settings() {
		return get_option( 'wpblmachine_settings' );
	}

	function wpblmachine_save_plugin_settings( $settings ) {
		return update_option( 'wpblmachine_settings', $settings );
	}

	add_action ( 'wp_ajax_wpblmachine_get_backlinks', 'wpblmachine_do_get_backlinks' );
	add_action ( 'wp_ajax_wpblmachine_get_tags', 'wpblmachine_do_get_tags' );

	function wpblmachine_do_get_backlinks() {
		$post_id = isset( $_POST['post_id'] ) ? intval( $_POST['post_id'] ) : 0;
		$num = isset( $_POST['num'] ) ? intval( $_POST['num'] ) : 10;
		$keywords = isset( $_POST['keywords'] ) ? trim( $_POST['keywords'] ) : '';
		// var_dump($post_id);
		$keywords_array = preg_split('/\r\n|[\r\n]/', $keywords );
		$url = get_permalink( $post_id );
		// var_dump($keywords_array);
		// die();
		if( !$post_id || empty( $keywords ) )
			die( 'Error: There was an error with your request. Please make sure to fill all fields and try again later' );
		$settings = array('');
		$job = wpblmachine_submit_job( $url, $keywords_array, $num );
		// var_dump($job);
		// $job = array( 1, 1000 );

		if( $job[0] ) {
			$job_id = $job[1];
			wpblmachine_add_to_log( $post_id, $job_id, $num, $keywords_array, 1 );
			echo '<p>Great! Our minions are going to start building your links. Please wait 48 hours for all your links to be processed and then you will be able to see a report in our <a href="https://backlinkmachine.com/app" target="_blank">Web App</a> or in the logs inside the plugin. We drip feed all the links over a period of 4 to 10 days so it appears natural to Google.</p>';
			echo '<p>Job ID <b>'.$job_id.'</b></p>';
			/*echo '<p>Job Submitted successfully, please login to <a href="https://backlinkmachine.com/app" target="_blank">backlinkmachine.com</a> to get your backlink report after 48hrs.</p>
				<p>Enter the JOB ID <b>'.$job_id.'</b> to get your report</p>';*/
		}
		else {
			die( 'Error 1: There was an error with your submission. Please try again later. Reason: '.$job[1] );
		}
		exit();
	}

	function wpblmachine_do_get_tags() {
		$post_id = isset( $_POST['post_id'] ) ? intval( $_POST['post_id'] ) : 0;
		$post_type = get_post_type( $post_id );
		if( $post_type == 'product' ) {
			// WooCommerce product
	    	$tags = wp_get_post_terms( $post_id, 'product_tag' );
		}
		else {
	    	$tags = wp_get_post_terms( $post_id, 'post_tag' );
		}

		if( $tags ) {
			$num_tags = count( $tags );
			foreach( $tags as $index => $tag ) {
				echo $tag->name;
				if( ( $index +1 ) < $num_tags )
					echo "\n";
			}
		}
		exit();
	}

	function wpblmachine_add_to_log( $post_id, $job_id = 0, $num_links = 0, $keywords = array(), $result = 0, $type = 0 ) {
		global $wpdb;
		$wpdb->insert ( $wpdb->prefix.'blmachine_requests' , array (
				'post_id' => intval( $post_id ),
				'keywords' => json_encode( $keywords ),
				'num_links' => intval( $num_links ),
				'job_id' => intval( $job_id ),
				'result' => intval( $result ),
				'created_at' => /*date("Y-m-d h:m:s")*/current_time( 'mysql' ),
				'bl_type' => $type
		) );
	}

	function wpblmachine_get_log( $page = 0, $per_page = 50 ) {
		global $wpdb;
		$page = $page * $per_page;
		$sql = "SELECT r.*, DATE_FORMAT(created_at, '%a %e %M %Y - %H:%i:%s') AS created_at_f FROM ".$wpdb->prefix."blmachine_requests r ORDER BY id DESC LIMIT $page, $per_page";
		return $wpdb->get_results( $sql );
	}

	function wpblmachine_is_valid_api() {
		return get_option( 'wpblmchine_valid_api', false );
	}

	function wpblmachine_set_valid_api() {
		return update_option( 'wpblmchine_valid_api', 1 );
	}

	function wpblmachine_get_post_types() {
		$args = array(
			'public'   => true,
			// '_builtin' => true
		);

		$output = 'objects'; // names or objects, note names is the default
		$operator = 'and'; // 'and' or 'or'

		return get_post_types( $args, $output/*, $operator*/ );
	}
	/* Activation / Deactivation */

	function wpblmachine_activation() {
		global $wpdb;

		$table_name = $wpdb->prefix . "blmachine_requests";
		$charset_collate = $wpdb->get_charset_collate ();

		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			id int(11) NOT NULL AUTO_INCREMENT,
			post_id int(11) NOT NULL,
			created_at datetime NOT NULL,
			keywords varchar(1024) NOT NULL,
			num_links tinyint(4) NOT NULL DEFAULT '0',
			job_id int(11) NOT NULL DEFAULT '0',
			result tinyint(4) NOT NULL DEFAULT '0',
			bl_type BOOLEAN NOT NULL DEFAULT 0,
		   UNIQUE KEY id (id)
		   ) $charset_collate;";

		require_once ( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta ( $sql );
	}

	/* Auto Backlinks */

	add_action( 'publish_post' , 'wpbacklinks_new_post' , 10 , 2 );
	add_action( 'publish_page' , 'wpbacklinks_new_post' , 10 , 2 );
	function wpbacklinks_new_post( $post_id , $post )
	{
		if( !in_array( get_post_type( $post_id ), array( 'post', 'page' ) ) )
			return;

		if ( $post->post_date == $post->post_modified )
		{
			$plugin_settings = wpblmachine_get_plugin_settings();
			// var_dump($plugin_settings);die();
			if( empty( $plugin_settings ) || ! isset( $plugin_settings['auto'] ) || ! $plugin_settings['auto'] || ! isset( $plugin_settings['num_blinks'] ) || ! $plugin_settings['num_blinks'] )
				return $post_id;
			// Post just got published
  	  		$keywords = get_post_meta( $post_id, 'wpblmachine_keywords', true ) ;
  	  		if( !$keywords ) {
				$keywords = ( isset( $_POST['wpblmachine_keywords'] ) ? esc_textarea( $_POST['wpblmachine_keywords'] ) : '' );
  	  		}

  	  		if( !$keywords && isset( $plugin_settings['kw_tags'])  && $plugin_settings['kw_tags'] ) {
  		    	$tags = wp_get_post_terms( $post_id, 'post_tag' );
  	  			if( $tags ) {
  	  				$keywords = "";
  	  				$num_tags = count( $tags );
  	  				foreach( $tags as $index => $tag ) {
  	  					$keywords .= $tag->name;
  	  					if( ( $index +1 ) < $num_tags )
  	  						$keywords .= "\n";
  	  				}
  	  			}
  	  		}

  	  		if( !$keywords )
  	  			$keywords = isset( $plugin_settings['default_kw'] ) ? $plugin_settings['default_kw'] : '';

  	  		$num = $plugin_settings['num_blinks'];
			// var_dump($keywords);
// die();
  	  		if( empty( $keywords ) )
  	  			return $post_id;
			$keywords_array = preg_split('/\r\n|[\r\n]/', $keywords );
			// var_dump($keywords_array);
  	  		// die($keywords);
			if( !empty( $keywords_array ) ) {
				$job = wpblmachine_submit_job( get_permalink( $post_id ), $keywords_array, $num );
				// var_dump($job);
				// die();
				if( isset( $job[0]) && $job[0] ) {
					$job_id = $job[1];
					wpblmachine_add_to_log( $post_id, $job_id, $num, $keywords_array, 1, 1 );
  	  				update_post_meta( $post_id, 'wpblmachine_jobid', $job_id ) ;
				}
				// die();
			}
		}
	}


	function backlinkmachine_check_upgrade_db() {
		if ( !get_option( 'backlinkmachine_version', 0 ) )  {
			// we assume we are on 1.53 or less
			backlinkmachine_fix_db_prefix();
			update_option( 'backlinkmachine_version', WPBLMACHINE_VERSION );
		}
		else if( get_option( 'backlinkmachine_version', 0 ) < 1.6 ) {
			//do nothing for now
			backlinkmachine_fix_db_prefix();
			update_option( 'backlinkmachine_version', WPBLMACHINE_VERSION );
		}

	}
	add_action('admin_init', 'backlinkmachine_check_upgrade_db');

	// create table with prefix
	function backlinkmachine_fix_db_prefix() {
		wpblmachine_activation();
	}
?>