<?php
	define( 'WPBLMACHINE_API_URL', 'https://backlinkmachine.com/app/apiv2.php' );
	define( 'WPBLMACHINE_REPORTS_URL', 'https://backlinkmachine.com/app/report.php' );

	// define( 'WPBLMACHINE_API_URL', 'http://localhost/backlinkmachine/apiv2.php' );
	// define( 'WPBLMACHINE_REPORTS_URL', 'http://localhost/backlinkmachine/report.php' );

	function wpblmachine_do_request( $url, $args = false ) {
		set_time_limit( 600 );
		$settings = wpblmachine_get_plugin_settings();
		// var_dump($settings);
		if ( ! isset( $settings['email'] ) || empty( $settings['email'] ) || ! isset( $settings['apikey'] ) || empty( $settings['apikey'] ) )
			return false;

		$params = array(
			'key' => $settings['apikey'],
			'email' => $settings['email']
		);

		$url = add_query_arg( $params, $url );

		// curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

		$req_args = array(
			'method' 	  => 'POST',
		    'timeout'     => 100,
		    /*'redirection' => 5,
		    'httpversion' => '1.0',
		    'user-agent'  => 'WordPress/' . $wp_version . '; ' . home_url(),
		    'blocking'    => true,
		    'headers'     => array(),
		    'cookies'     => array(),
		    'body'        => null,
		    'compress'    => false,
		    'decompress'  => true,*/
		    'sslverify'   => false/*,
		    'stream'      => false,
		    'filename'    => null*/
		);
		if( $args ) {
			$req_args['body'] = $args;
		}

// echo $url.'<br/>';
		$response = wp_remote_post( $url, $req_args );

		if( is_array($response) ) {
		  $header = $response['headers']; // array of http header lines
		  $body = $response['body']; // use the content
		  return $body;
		}
		else {
		    $ch = curl_init();
		    curl_setopt($ch,CURLOPT_URL, $url);
    		curl_setopt($ch,CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    		curl_setopt($ch,CURLOPT_FOLLOWLOCATION, 1);
    		if( $args ) {
				curl_setopt($ch, CURLOPT_POSTFIELDS, $args);
    		}
		    $data = curl_exec($ch);
		    curl_close($ch);
		    return $data;
		}
		return false;
	}

	/* Keywords is an array of keywords */
	function wpblmachine_submit_job( $url, $keywords, $num = 10 ) {
		// return 2136866;
		$params = array(
			'action' => 'backlink',
			'numlinks' => $num/*,
			'url[]' => urlencode( $url ),
			'keywords' => implode( $keywords, '|'),*/
			);

		$args = array (
			'url[]' => urlencode( $url )
		);

		if( $keywords )	{
			$i = 0;
			foreach( $keywords as $keyword ) {
				$args['keyword['.$i++.']'] = trim( $keyword );
			}
		}

		wpblmachine_did_request( 1 );
		$url = add_query_arg( $params, WPBLMACHINE_API_URL );
		// die($url);
		if( WPBLMACHINE_DEBUG_MODE ) {
			return array( 1, 1 );
		}
		$result = wpblmachine_do_request( $url, $args );
		// var_dump($result);
		$result = json_decode( $result );
		if( $result && $result->result )
			return array( 1, $result->text );
		return array( 0, $result->text );
	}

	function wpblmachine_get_remaining_links( $force_read = 0 ) {
		// rmi353, transient
		// delete_transient( 'wpblmachine_rem_links' );
		$wpblmachine_rem_links = 0;
		if ( ( get_wpblmachine_did_request() == 1  ) || (false === ( $wpblmachine_rem_links = get_transient( 'wpblmachine_rem_links' ) ) ) ) {
		    // It wasn't there, so regenerate the data and save the transient
		    $url = add_query_arg( 'action', 'credits', WPBLMACHINE_API_URL );
		    $result = wpblmachine_do_request( $url );
		    $result = json_decode( $result );
		    // var_dump($result);
		    if( !$result || !isset( $result->result ) )
		    	return 0;
		    if( $result->result )
		     $wpblmachine_rem_links = $result->text;
		 	else
		 		$wpblmachine_rem_links = 0;
		     set_transient( 'wpblmachine_rem_links', $wpblmachine_rem_links, 1 * HOUR_IN_SECONDS );
		     wpblmachine_did_request( 0 );
		}

		return $wpblmachine_rem_links;
		return 0;
	}

	function wpblmachine_api_test_api_key( $email, $key ) {
		$url = add_query_arg( 'action', 'testapi', WPBLMACHINE_API_URL );
		$result = wpblmachine_do_request( $url );
		if( empty( $result ) )
			return false;
		$result = json_decode( $result );
		if( !$result || !isset( $result->result ) )
			return false;
		if( $result->result )
			return true;
		return false;
	}

	function wpblmachine_did_request( $val ) {
		update_option( 'wpblmachine_did_request', $val );
	}

	function get_wpblmachine_did_request() {
		return get_option( 'wpblmachine_did_request', 0 );
	}
?>